/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.userprof;

import com.ibm.hwmca.base.userprof.RoleTree;
import com.ibm.hwmca.base.userprof.UserAttributes;
import com.ibm.hwmca.base.userprof.UserProfErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.util.ArrayList;
import java.util.List;

public class NewUserBean
extends PanelBean
implements UserProfErrorIds {
    private String m_sUserid = null;
    private String m_sDescription = null;
    private String m_sPassword = null;
    private String m_sConfirmPassword = null;
    private String m_sExpireDaysField = null;
    private boolean m_bEnforcePassword = false;
    private boolean m_bRemoteAccess = false;
    private ItemDescriptor[] m_idObjectRoles;
    private ColumnDescriptor[] m_cdObjectRolesStructure;
    private int[] m_iObjectRolesSelection;
    private ItemDescriptor[] m_idTaskRoles;
    private ColumnDescriptor[] m_cdTaskRolesStructure;
    private int[] m_iTaskRolesSelection;
    UserTaskManager _utm;
    List _systemObjects = new ArrayList();
    List _systemTasks = new ArrayList();
    List _systemUsers = new ArrayList();
    List _objectData = new ArrayList();
    List _taskData = new ArrayList();
    List _currentUser;
    UserAttributes _curUser;
    boolean multipleSelections = true;
    boolean modifyTask = false;
    boolean copyTask = false;
    boolean caseSensitive;
    boolean multipleTasks;
    boolean multipleObjects;
    boolean pwChangeOnly;
    boolean remoteAccess;
    boolean remoteAccessApplies;
    private static final String TRACE_MASKF = "NEWUSRSF";
    private static final String TRACE_MASKT = "NEWUSRST";
    private static final String TRACE_MASKD = "NEWUSRSD";

    public NewUserBean(List myTasks, List myObjects, UserAttributes myUser, boolean sensitivity, boolean multipleTasks, boolean multipleObjects, boolean pwOnly, boolean remoteAuthValid) {
        this._systemTasks = myTasks;
        this._systemObjects = myObjects;
        this.modifyTask = true;
        this.copyTask = false;
        this._curUser = myUser;
        this.caseSensitive = sensitivity;
        this.multipleTasks = multipleTasks;
        this.multipleObjects = multipleObjects;
        this.pwChangeOnly = pwOnly;
        this.remoteAccessApplies = remoteAuthValid;
        Trace.trace(TRACE_MASKT, "NewUserBean.newuserbean modify remoteaccessapplies " + this.remoteAccessApplies);
        this.remoteAccess = this.remoteAccessApplies ? myUser.isRemoteAccessPermitted() : false;
        Trace.trace(TRACE_MASKT, "NewUserBean.newuserbean modify remoteaccess value " + this.remoteAccess);
        Trace.trace(TRACE_MASKT, "NewUserBean.modify");
        Trace.trace(TRACE_MASKT, "myTasks size " + myTasks.size());
        Trace.trace(TRACE_MASKT, "myObjects size " + myObjects.size());
        Trace.trace(TRACE_MASKT, "myUser is " + myUser.getUserid());
        Trace.trace(TRACE_MASKT, "casesensitivity " + this.caseSensitive);
        Trace.trace(TRACE_MASKT, "multipleTasks " + multipleTasks);
        Trace.trace(TRACE_MASKT, "multipleObjects " + multipleObjects);
    }

    public NewUserBean(List myTasks, List myObjects, List myUsers, UserAttributes myUser, boolean sensitivity, boolean multipleTasks, boolean multipleObjects, boolean remoteAuthValid) {
        this._systemTasks = myTasks;
        this._systemObjects = myObjects;
        this._systemUsers = myUsers;
        this.modifyTask = false;
        this.copyTask = true;
        this._curUser = myUser;
        this.caseSensitive = sensitivity;
        this.multipleTasks = multipleTasks;
        this.multipleObjects = multipleObjects;
        this.remoteAccessApplies = remoteAuthValid;
        this.remoteAccess = this.remoteAccessApplies ? myUser.isRemoteAccessPermitted() : false;
        Trace.trace(TRACE_MASKT, "copy remoteAccessApplies " + this.remoteAccessApplies);
        Trace.trace(TRACE_MASKT, "copy remoteAccess value " + this.remoteAccess);
        this.pwChangeOnly = false;
        Trace.trace(TRACE_MASKT, "NewUserBean.copy");
        Trace.trace(TRACE_MASKT, "myTasks size " + myTasks.size());
        Trace.trace(TRACE_MASKT, "myObjects size " + myObjects.size());
        Trace.trace(TRACE_MASKT, "myUser is " + myUser.getUserid());
        Trace.trace(TRACE_MASKT, "casesensitivity " + this.caseSensitive);
        Trace.trace(TRACE_MASKT, "multipleTasks " + multipleTasks);
        Trace.trace(TRACE_MASKT, "multipleObjects " + multipleObjects);
    }

    public NewUserBean(List myTasks, List myObjects, List myUsers, boolean sensitivity, boolean multipleTasks, boolean multipleObjects, boolean remoteAuthValid) {
        this._systemTasks = myTasks;
        this._systemObjects = myObjects;
        this._systemUsers = myUsers;
        this.modifyTask = false;
        this.copyTask = false;
        this.caseSensitive = sensitivity;
        this.multipleTasks = multipleTasks;
        this.multipleObjects = multipleObjects;
        this.remoteAccessApplies = remoteAuthValid;
        this.remoteAccess = false;
        this.pwChangeOnly = false;
        Trace.trace(TRACE_MASKT, "NewUserBean.new");
        Trace.trace(TRACE_MASKT, "myTasks size " + myTasks.size());
        Trace.trace(TRACE_MASKT, "myObjects size " + myObjects.size());
        Trace.trace(TRACE_MASKT, "casesensitivity " + this.caseSensitive);
        Trace.trace(TRACE_MASKT, "multipleTasks " + multipleTasks);
        Trace.trace(TRACE_MASKT, "multipleObjects " + multipleObjects);
        Trace.trace(TRACE_MASKT, "remoteAccessApplies " + this.remoteAccessApplies);
        Trace.trace(TRACE_MASKT, "remoteAccess " + this.remoteAccess);
    }

    public String getUserid() {
        return this.m_sUserid;
    }

    public void setUserid(String s) throws IllegalUserDataException {
        this.m_sUserid = s;
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public void setDescription(String s) throws IllegalUserDataException {
        this.m_sDescription = s;
    }

    public String getPassword() {
        return this.m_sPassword;
    }

    public void setPassword(String s) throws IllegalUserDataException {
        this.m_sPassword = s;
    }

    public String getConfirmPassword() {
        return this.m_sConfirmPassword;
    }

    public void setConfirmPassword(String s) throws IllegalUserDataException {
        this.m_sConfirmPassword = s;
    }

    public String getExpireDaysField() {
        return this.m_sExpireDaysField;
    }

    public void setExpireDaysField(String s) throws IllegalUserDataException {
        this.m_sExpireDaysField = s;
    }

    public boolean isEnforcePassword() {
        return this.m_bEnforcePassword;
    }

    public void setEnforcePassword(boolean b) throws IllegalUserDataException {
        this.m_bEnforcePassword = b;
    }

    public void setRemoteAccess(boolean b) throws IllegalUserDataException {
        this.m_bRemoteAccess = b;
    }

    public boolean isRemoteAccess() {
        return this.m_bRemoteAccess;
    }

    public ColumnDescriptor[] getObjectRolesRowStructure() {
        return this.m_cdObjectRolesStructure;
    }

    public int getObjectRolesRowStatus() {
        return 3;
    }

    public int getObjectRolesRowCount() {
        int retCount = 0;
        if (this.m_idObjectRoles != null) {
            retCount = this.m_idObjectRoles.length;
        }
        return retCount;
    }

    public ItemDescriptor[] getObjectRolesRowAt(int index) {
        ItemDescriptor[] rowAt = new ItemDescriptor[]{new ItemDescriptor()};
        rowAt[0] = this.m_idObjectRoles[index];
        return rowAt;
    }

    public void setObjectRolesRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idObjectRoles[index] = items[0];
    }

    public int[] getObjectRolesSelection() {
        return this.m_iObjectRolesSelection;
    }

    public void setObjectRolesSelection(int[] selected) throws IllegalUserDataException {
        int i;
        int selectValue = 0;
        if (selected != null) {
            i = 0;
            while (i < selected.length) {
                selectValue = selected[i];
                ++i;
            }
        }
        this.m_iObjectRolesSelection = new int[selected.length];
        i = 0;
        while (i < selected.length) {
            this.m_iObjectRolesSelection[i] = selected[i];
            selectValue = selected[i];
            ++i;
        }
    }

    public ColumnDescriptor[] getTaskRolesRowStructure() {
        return this.m_cdTaskRolesStructure;
    }

    public int getTaskRolesRowStatus() {
        return 3;
    }

    public int getTaskRolesRowCount() {
        int retCount = 0;
        if (this.m_idTaskRoles != null) {
            retCount = this.m_idTaskRoles.length;
        }
        return retCount;
    }

    public ItemDescriptor[] getTaskRolesRowAt(int index) {
        ItemDescriptor[] rowAt = new ItemDescriptor[]{new ItemDescriptor()};
        rowAt[0] = this.m_idTaskRoles[index];
        return rowAt;
    }

    public void setTaskRolesRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idTaskRoles[index] = items[0];
    }

    public int[] getTaskRolesSelection() {
        return this.m_iTaskRolesSelection;
    }

    public void setTaskRolesSelection(int[] selected) throws IllegalUserDataException {
        int i;
        int selectValue = 0;
        if (selected != null) {
            i = 0;
            while (i < selected.length) {
                selectValue = selected[i];
                ++i;
            }
        }
        this.m_iTaskRolesSelection = new int[selected.length];
        i = 0;
        while (i < selected.length) {
            this.m_iTaskRolesSelection[i] = selected[i];
            selectValue = selected[i];
            ++i;
        }
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void prepare() {
        if (this.pwChangeOnly) {
            this.userTaskManager.setEnabled("Userid", false);
            this.userTaskManager.setEnabled("Description", false);
            this.userTaskManager.setEnabled("ExpireDaysField", false);
            this.userTaskManager.setEnabled("EnforcePassword", false);
            this.userTaskManager.setEnabled("ObjectRoles", false);
            this.userTaskManager.setEnabled("TaskRoles", false);
            this.userTaskManager.setCaptionText("NewUserPanel", new BaseMessageTitle("ADM9018").toString());
        } else if (this.modifyTask) {
            this.userTaskManager.setEnabled("Userid", false);
            this.userTaskManager.setCaptionText("NewUserPanel", new BaseMessageTitle("ADM9018").toString());
        } else if (this.copyTask) {
            this.userTaskManager.setEnabled("Userid", true);
            this.userTaskManager.setEnabled("Password", true);
            this.userTaskManager.setEnabled("ConfirmPassword", true);
            this.userTaskManager.setCaptionText("NewUserPanel", new BaseMessageTitle("ADM9019").toString());
        } else {
            this.userTaskManager.setCaptionText("NewUserPanel", new BaseMessageTitle("ADM9020").toString());
        }
        if (this.multipleObjects) {
            this.userTaskManager.setAttribute("ObjectRoles", 16, "MULTIPLE");
        } else {
            this.userTaskManager.setAttribute("ObjectRoles", 16, "SINGLE");
        }
        if (this.multipleTasks) {
            this.userTaskManager.setAttribute("TaskRoles", 16, "MULTIPLE");
        } else {
            this.userTaskManager.setAttribute("TaskRoles", 16, "SINGLE");
        }
        if (this.pwChangeOnly) {
            if (this.remoteAccessApplies) {
                this.userTaskManager.setEnabled("RemoteAccess", false);
            } else {
                this.userTaskManager.setShown("RemoteAccess", false);
            }
        } else if (!this.remoteAccessApplies) {
            this.userTaskManager.setShown("RemoteAccess", false);
        }
        this.setUTM(this.userTaskManager);
    }

    public void setUTM(UserTaskManager utm) {
        this._utm = utm;
        this.fillTables();
        if (this.modifyTask || this.copyTask) {
            this.fillIdValues();
        }
    }

    public UserTaskManager getUTM() {
        return this._utm;
    }

    public void load() {
        if (this.modifyTask || this.copyTask) {
            if (this._curUser.isPasswordRulesEnforced()) {
                if (!this.pwChangeOnly) {
                    this.setEnforcePassword(true);
                }
                this.setExpireDaysField("1");
                int value = this._curUser.getPasswordExpiration();
                this.setExpireDaysField(Integer.toString(value));
            }
            if (this.remoteAccessApplies) {
                this.setRemoteAccess(this._curUser.isRemoteAccessPermitted());
            }
        } else {
            this.m_bEnforcePassword = false;
            this.m_bRemoteAccess = false;
        }
    }

    public void panelAction(TaskActionEvent event) {
        Object mySelection = null;
        String actionCommand = event.getActionCommand();
        String command = event.getElementName();
        PanelTaskletRequest request = new PanelTaskletRequest();
        boolean nameValid = false;
        boolean itemExists = false;
        boolean remoteAccess = false;
        Object expireDays = null;
        boolean result = true;
        UserTaskManager utm = (UserTaskManager)event.getSource();
        if (command.equals("okButton")) {
            try {
                utm.storeAllElements();
            }
            catch (Exception e) {
                System.out.println("something should not be blank");
            }
            Trace.trace(TRACE_MASKT, "-> NewUserBean:okbutton()");
            Trace.trace(TRACE_MASKT, "-> modifyTask flag = " + this.modifyTask);
            Trace.trace(TRACE_MASKT, "-> m_bEnforcePassword flag is " + this.m_bEnforcePassword);
            Trace.trace(TRACE_MASKT, "-> pwChangeOnly flag is " + this.pwChangeOnly);
            if (this.modifyTask || this.copyTask) {
                Trace.trace(TRACE_MASKT, "-> startup passwordEnforced = " + this._curUser.isPasswordRulesEnforced());
            }
            String newName = this.getUserid();
            remoteAccess = this.remoteAccessApplies ? this.isRemoteAccess() : false;
            if (this.pwChangeOnly) {
                result = this.verifyPasswordLengths();
                if (!result) {
                    return;
                }
                result = this.verifyConfirmPasswordLengths();
                if (!result) {
                    return;
                }
                result = this.verifyPasswordEquality();
                if (!result) {
                    return;
                }
                request.setData("action", "modifyUserPassword");
                request.setData("name", newName);
                request.setData("description", this.getDescription());
                request.setData("password", this.getPassword());
                if (!this.m_bEnforcePassword) {
                    request.setData("expireDays", "0");
                } else {
                    request.setData("expireDays", this.getExpireDaysField());
                }
                this.postTaskletRequest(request);
            } else {
                if (!this.modifyTask) {
                    result = this.verifyNameLength(newName);
                    if (!result) {
                        return;
                    }
                    result = this.verifyDescription();
                    if (!result) {
                        return;
                    }
                    result = this.verifyPasswordLengths();
                    if (!result) {
                        return;
                    }
                    result = this.verifyConfirmPasswordLengths();
                    if (!result) {
                        return;
                    }
                    result = this.verifyPasswordEquality();
                    if (!result) {
                        return;
                    }
                    if (this.m_bEnforcePassword) {
                        result = this.verifyExpireDays();
                        if (!result) {
                            return;
                        }
                        request.setData("expireDays", this.getExpireDaysField());
                    } else {
                        request.setData("expireDays", "0");
                    }
                } else {
                    result = this.verifyDescription();
                    if (!result) {
                        return;
                    }
                    if (!this._curUser.isPasswordRulesEnforced()) {
                        Trace.trace(TRACE_MASKT, "-> NewUserBean:startup password not enforced");
                        if (this.m_bEnforcePassword) {
                            Trace.trace(TRACE_MASKT, "-> NewUserBean:m_bEnforcePassword true");
                            result = this.verifyPasswordLengths();
                            if (!result) {
                                return;
                            }
                            result = this.verifyConfirmPasswordLengths();
                            if (!result) {
                                return;
                            }
                            result = this.verifyPasswordEquality();
                            if (!result) {
                                return;
                            }
                            result = this.verifyExpireDays();
                            if (!result) {
                                return;
                            }
                        } else if (this.getPassword() != null && this.getPassword().length() > 1 || this.getConfirmPassword() != null && this.getConfirmPassword().length() > 1) {
                            result = this.verifyPasswordLengths();
                            if (!result) {
                                return;
                            }
                            result = this.verifyConfirmPasswordLengths();
                            if (!result) {
                                return;
                            }
                            result = this.verifyPasswordEquality();
                            if (!result) {
                                return;
                            }
                        }
                    } else if (this.m_bEnforcePassword) {
                        if (this.getPassword() != null && this.getPassword().length() > 1 || this.getConfirmPassword() != null && this.getConfirmPassword().length() > 1) {
                            result = this.verifyPasswordLengths();
                            if (!result) {
                                return;
                            }
                            result = this.verifyConfirmPasswordLengths();
                            if (!result) {
                                return;
                            }
                            result = this.verifyPasswordEquality();
                            if (!result) {
                                return;
                            }
                        }
                        if (!(result = this.verifyExpireDays())) {
                            return;
                        }
                    } else {
                        Trace.trace(TRACE_MASKT, "-> NewUserBean:modify password enforced at startup");
                        if (this.getPassword() != null && this.getPassword().length() > 1 || this.getConfirmPassword() != null && this.getConfirmPassword().length() > 1) {
                            result = this.verifyPasswordLengths();
                            if (!result) {
                                return;
                            }
                            result = this.verifyConfirmPasswordLengths();
                            if (!result) {
                                return;
                            }
                            result = this.verifyPasswordEquality();
                            if (!result) {
                                return;
                            }
                        }
                    }
                }
                if (!this.m_bEnforcePassword) {
                    request.setData("expireDays", "0");
                } else {
                    request.setData("expireDays", this.getExpireDaysField());
                }
                if (this.modifyTask) {
                    request.setData("action", "modifyUser");
                    request.setData("name", newName);
                    if (this.getPassword() == null || this.getPassword().length() < 1) {
                        request.setData("pwchange", new Integer(0));
                    } else {
                        request.setData("pwchange", new Integer(1));
                        request.setData("password", this.getPassword());
                    }
                    request.setData("description", this.getDescription());
                    this.buildObjectData(this._objectData);
                    this.buildTaskData(this._taskData);
                    request.setData("objectData", this._objectData);
                    request.setData("taskData", this._taskData);
                    if (this.remoteAccessApplies) {
                        if (this.m_bRemoteAccess) {
                            request.setData("remoteAccess", new Integer(1));
                        } else {
                            request.setData("remoteAccess", new Integer(0));
                        }
                    } else {
                        request.setData("remoteAccess", new Integer(0));
                    }
                    this.postTaskletRequest(request);
                } else {
                    request.setData("action", "addUser");
                    request.setData("name", newName);
                    request.setData("password", this.getPassword());
                    request.setData("description", this.getDescription());
                    this.buildObjectData(this._objectData);
                    this.buildTaskData(this._taskData);
                    request.setData("objectData", this._objectData);
                    request.setData("taskData", this._taskData);
                    if (this.remoteAccessApplies) {
                        if (this.m_bRemoteAccess) {
                            request.setData("remoteAccess", new Integer(1));
                        } else {
                            request.setData("remoteAccess", new Integer(0));
                        }
                    } else {
                        request.setData("remoteAccess", new Integer(0));
                    }
                    this.postTaskletRequest(request);
                }
            }
        } else if (actionCommand.equalsIgnoreCase("CANCEL")) {
            request.setCanceled();
            this.postTaskletRequest(request);
        } else {
            this.dispose();
        }
    }

    public List buildObjectData(List _objectData) {
        RoleTree curTree = null;
        if (this.m_iObjectRolesSelection != null) {
            int i = 0;
            while (i < this.m_iObjectRolesSelection.length) {
                Trace.trace(TRACE_MASKD, "<> buildObjectData: item " + this.m_iObjectRolesSelection[i]);
                curTree = (RoleTree)this._systemObjects.get(this.m_iObjectRolesSelection[i]);
                _objectData.add(curTree);
                ++i;
            }
        }
        return _objectData;
    }

    public List buildTaskData(List _taskData) {
        RoleTree curTree = null;
        if (this.m_iTaskRolesSelection != null) {
            int i = 0;
            while (i < this.m_iTaskRolesSelection.length) {
                Trace.trace(TRACE_MASKD, "<> buildTaskData: item " + this.m_iTaskRolesSelection[i]);
                curTree = (RoleTree)this._systemTasks.get(this.m_iTaskRolesSelection[i]);
                _taskData.add(curTree);
                ++i;
            }
        }
        return _taskData;
    }

    public void fillTables() {
        String itemName;
        RoleTree itemTree;
        ItemDescriptor[] newRow;
        Trace.trace(TRACE_MASKT, "--> fillTables");
        Trace.trace(TRACE_MASKT, "--> systemTasks size " + this._systemTasks.size());
        Trace.trace(TRACE_MASKT, "--> systemObjects size " + this._systemObjects.size());
        int i = 0;
        int taskSize = 0;
        int objectSize = 0;
        taskSize = this._systemTasks.size();
        this.m_idTaskRoles = new ItemDescriptor[taskSize];
        this.m_cdTaskRolesStructure = new ColumnDescriptor[0];
        this.m_iTaskRolesSelection = new int[1];
        this.m_iTaskRolesSelection[0] = 0;
        objectSize = this._systemObjects.size();
        this.m_idObjectRoles = new ItemDescriptor[objectSize];
        this.m_cdObjectRolesStructure = new ColumnDescriptor[0];
        this.m_iObjectRolesSelection = new int[1];
        this.m_iObjectRolesSelection[0] = 0;
        i = 0;
        while (i < taskSize) {
            newRow = new ItemDescriptor[1];
            itemTree = (RoleTree)this._systemTasks.get(i);
            itemName = itemTree.getName().toString();
            newRow[0] = new ItemDescriptor("i" + String.valueOf(i), itemName);
            this.setTaskRolesRowAt(i, newRow);
            ++i;
        }
        i = 0;
        while (i < objectSize) {
            newRow = new ItemDescriptor[1];
            itemTree = (RoleTree)this._systemObjects.get(i);
            itemName = itemTree.getName().toString();
            newRow[0] = new ItemDescriptor("xi" + String.valueOf(i), itemName);
            this.setObjectRolesRowAt(i, newRow);
            ++i;
        }
    }

    public void fillIdValues() {
        this.setUserid(this._curUser.getUserid());
        this.setDescription(this._curUser.getDescription().toString());
        this.highlightFields();
    }

    public void highlightFields() {
        List moRoles = this._curUser.getRoles(0);
        Trace.trace(TRACE_MASKT, "-> NewUserBean:highlightFields moRoles size " + moRoles.size());
        Trace.trace(TRACE_MASKT, "-> NewUserBean:dump moroles ");
        int m = 0;
        while (m < moRoles.size()) {
            Trace.trace(TRACE_MASKT, "NewUserBean morole Item " + moRoles.get(m));
            ++m;
        }
        List taskRoles = this._curUser.getRoles(1);
        Trace.trace(TRACE_MASKT, "-> NewUserBean:highlightFields taskRoles size " + taskRoles.size());
        Trace.trace(TRACE_MASKT, "-> NewUserBean:dump taskroles ");
        int t = 0;
        while (t < taskRoles.size()) {
            Trace.trace(TRACE_MASKT, "NewUserBean taskrole Item " + taskRoles.get(t));
            ++t;
        }
        int[] roleSelections = new int[taskRoles.size()];
        int x = 0;
        while (x < taskRoles.size()) {
            int roleCount = this.getTaskRolesRowCount();
            int r = 0;
            while (r < roleCount) {
                RoleTree curTree;
                String desc;
                String roleName = this.m_idTaskRoles[r].getTitle();
                if (roleName.equals(desc = (curTree = (RoleTree)taskRoles.get(x)).getName().toString())) {
                    roleSelections[x] = r;
                    r = roleCount;
                }
                ++r;
            }
            ++x;
        }
        this.setTaskRolesSelection(roleSelections);
        roleSelections = new int[moRoles.size()];
        this.m_iObjectRolesSelection[0] = 0;
        int x2 = 0;
        while (x2 < moRoles.size()) {
            int roleCount = this.getObjectRolesRowCount();
            int r = 0;
            while (r < roleCount) {
                String nodeName;
                String roleName = this.m_idObjectRoles[r].getTitle();
                if (roleName.equals(nodeName = ((RoleTree)moRoles.get(x2)).getName().toString())) {
                    roleSelections[x2] = r;
                    r = roleCount;
                }
                ++r;
            }
            ++x2;
        }
        this.setObjectRolesSelection(roleSelections);
    }

    public boolean verifyNameLength(String newName) {
        boolean result = true;
        Trace.trace(TRACE_MASKT, "-> NewUserBean:verifyNameLength " + newName);
        if (newName == null) {
            try {
                BaseMessageTitle title = new BaseMessageTitle("HACA800C");
                BaseMessageText msg = new BaseMessageText("HACA000M");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
            }
            catch (Exception e) {
                // empty catch block
            }
            result = false;
        }
        Trace.trace(TRACE_MASKT, "<- NewUserBean:verifyNameLength " + result);
        return result;
    }

    public boolean verifyDescription() {
        boolean result = true;
        if (this.getDescription() == null || this.getDescription().length() < 1) {
            try {
                BaseMessageTitle title = new BaseMessageTitle("ADM9008");
                BaseMessageText msg = new BaseMessageText("ADM0010");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
            }
            catch (Exception e) {
                // empty catch block
            }
            result = false;
        }
        return result;
    }

    public boolean verifyPasswordLengths() {
        boolean result = true;
        if (this.getPassword() == null || this.getPassword().length() < 1) {
            try {
                BaseMessageTitle title = new BaseMessageTitle("HACA8003");
                BaseMessageText msg = new BaseMessageText("ADM0024");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
            }
            catch (Exception e) {
                // empty catch block
            }
            return false;
        }
        return result;
    }

    public boolean verifyConfirmPasswordLengths() {
        boolean result = true;
        if (this.getConfirmPassword() == null || this.getConfirmPassword().length() < 1) {
            try {
                BaseMessageTitle title = new BaseMessageTitle("HACA800M");
                BaseMessageText msg = new BaseMessageText("ADM0024");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
            }
            catch (Exception e) {
                // empty catch block
            }
            return false;
        }
        return result;
    }

    public boolean verifyExpireDays() {
        int expDays;
        BaseMessageText msg;
        BaseMessageTitle title;
        boolean result = true;
        Trace.trace(TRACE_MASKT, "-> NewUserBean:verifyExpireDays()");
        String expireDays = this.getExpireDaysField();
        if (expireDays == null || expireDays.length() < 1) {
            try {
                BaseMessageTitle title2 = new BaseMessageTitle("ADM9009");
                BaseMessageText msg2 = new BaseMessageText("ADM0011");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title2, msg2);
            }
            catch (Exception e) {
                // empty catch block
            }
            result = false;
        }
        if (result) {
            int i = 0;
            while (i < expireDays.length()) {
                if (expireDays.charAt(i) < '0' || expireDays.charAt(i) > '9') {
                    try {
                        title = new BaseMessageTitle("ADM9009");
                        msg = new BaseMessageText("ADM0022");
                        CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    result = false;
                    i = expireDays.length();
                }
                ++i;
            }
        }
        if (result && ((expDays = Integer.valueOf(expireDays).intValue()) < 1 || expDays > 180)) {
            try {
                title = new BaseMessageTitle("ADM9009");
                msg = new BaseMessageText("ADM0020");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
            }
            catch (Exception e) {
                // empty catch block
            }
            result = false;
        }
        Trace.trace(TRACE_MASKT, "<- NewUserBean:verifyExpireDays() " + result);
        return result;
    }

    public boolean verifyPasswordEquality() {
        boolean result = true;
        if (this.caseSensitive) {
            if (!this.getPassword().equals(this.getConfirmPassword())) {
                try {
                    BaseMessageTitle title = new BaseMessageTitle("HACA8004");
                    BaseMessageText msg = new BaseMessageText("HACA0004");
                    CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
                }
                catch (Exception e) {
                    // empty catch block
                }
                result = false;
            }
        } else if (!this.getPassword().toUpperCase().equals(this.getConfirmPassword().toUpperCase())) {
            try {
                BaseMessageTitle title = new BaseMessageTitle("HACA8004");
                BaseMessageText msg = new BaseMessageText("HACA0004");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
            }
            catch (Exception e) {
                // empty catch block
            }
            result = false;
        }
        return result;
    }
}

